﻿// Correction Web6c V2b
// Solution avec un formulaire et une fonction changejauge()
$(document).ready(function () {
    // Initialisation de la jauge JQuery
    $('#jaugeTemperature').jqxGauge({
        ranges: [{ startValue: 0, endValue: 15, style: { fill: '#C9C9C9', stroke: '#C9C9C9' }, endWidth: 3, startWidth: 1 },
        { startValue: 15, endValue: 30, style: { fill: '#FCF06A', stroke: '#FCF06A' }, endWidth: 6, startWidth: 3 },
        { startValue: 30, endValue: 40, style: { fill: '#FCA76A', stroke: '#FCA76A' }, endWidth: 9, startWidth: 6 },
        { startValue: 40, endValue: 50, style: { fill: '#FC6A6A', stroke: '#FC6A6A' }, endWidth: 12, startWidth: 9 }],
        ticksMinor: { interval: 1, size: '5%' },
        ticksMajor: { interval: 5, size: '9%' },
        max: 50,
        labels: { interval: 5 },
        caption: { value: "Temp °C" },
        width: 200,
        height: 200,
        animationDuration: 200
    });

    // Déclaration et initialisation des variables
    var couleurBord = '#C9C9C9';

    function changejauge(temperature) {
        if (((temperature >= 18) && (temperature <= 23))) { // changerEchelle(18,23,1,0.1)
            $('#jaugeTemperature').jqxGauge({ // La position de l'aiguille est forcée sur 18°C
                value: 0,
                animationDuration: 0
            });
            $('#jaugeTemperature').jqxGauge({ // Traiter : modification de la résolution
                ranges: [{ startValue: 18, endValue: 23, style: { fill: '#FCF06A', stroke: '#FCF06A' }, endWidth: 3, startWidth: 1 }],
                min: 18,
                max: 23,
                ticksMinor: { interval: 0.1, size: '5%' },
                ticksMajor: { interval: 1, size: '9%' },
                labels: { interval: 1 },
                animationDuration: 200
            });

            couleurBord = '#FCF06A'; // Jaune
        }
        else { // changerEchelle(0,50,5,1)
            $('#jaugeTemperature').jqxGauge({ // Traiter : couleur du bord en fonction de la température 
                ranges: [{ startValue: 0, endValue: 15, style: { fill: '#C9C9C9', stroke: '#C9C9C9' }, endWidth: 3, startWidth: 1 },
                { startValue: 15, endValue: 30, style: { fill: '#FCF06A', stroke: '#FCF06A' }, endWidth: 6, startWidth: 3 },
                { startValue: 30, endValue: 40, style: { fill: '#FCA76A', stroke: '#FCA76A' }, endWidth: 9, startWidth: 6 },
                { startValue: 40, endValue: 50, style: { fill: '#FC6A6A', stroke: '#FC6A6A' }, endWidth: 12, startWidth: 9 }],
                ticksMinor: { interval: 1, size: '5%' },
                ticksMajor: { interval: 5, size: '9%' },
                min: 0,
                max: 50,
                labels: { interval: 5 },
                animationDuration: 200
            });

            if (temperature < 0) {
                couleurBord = '#000';
            }
            else if (temperature <= 15) {
                couleurBord = '#C9C9C9';
            }
            else if (temperature <= 30) {
                couleurBord = '#FCF06A';
            }
            else if (temperature <= 40) {
                couleurBord = '#FCA76A';
            }
            else if (temperature <= 50) {
                couleurBord = '#FC6A6A';
            }
            else {
                couleurBord = '#000';
            }
        }

        // Ecrire
        $('#jaugeTemperature').jqxGauge({
            border: { style: { fill: couleurBord, stroke: couleurBord } },
        });

        $('#jaugeTemperature').jqxGauge({ value: temperature });
    }

    // Lire : Touche formulaire + touche Enter
    $("input").keypress(function (event) {
        if (event.keyCode == 13) {
            event.preventDefault();
            let temp = $("#temperature").val();
            changejauge(temp);
        }
    });

    // Lire : Formulaire + BPTest
    $("#bptemp").click(function () {
        let temp = $("#temperature").val();
        changejauge(temp);
    });
});